implementation module StdMenuDef


//	Version 1.1

//	Definition of Menus and MenuElements:


import	StdIOCommon, StdMaybe


/*	Menus:				*/

::	Menu        m ls ps = Menu        Title         (m ls ps)        [MenuAttribute *(ls,ps)]


/*	Menu elements:		*/

::	SubMenu     m ls ps = SubMenu     Title         (m ls ps)        [MenuAttribute *(ls,ps)]
::	RadioMenu     ls ps = RadioMenu   [MenuRadioItem *(ls,ps)] Index [MenuAttribute *(ls,ps)]
::	MenuItem      ls ps = MenuItem    Title                          [MenuAttribute *(ls,ps)]
::	MenuSeparator ls ps = MenuSeparator                              [MenuAttribute *(ls,ps)]

::	MenuRadioItem ps  :== (Title,Maybe Id,Maybe Char,IOFunction ps)

::	MenuAttribute		ps								// Default:
//	Attributes for Menus and MenuElements:
	=	MenuId				Id							// no Id
	|	MenuSelectState		SelectState					// menu(item) Able
//	Attributes only for Menus:
	|	MenuIndex			Int							// at the end of the current menu list
//	Attributes ignored by (Sub)Menus:
	|	MenuShortKey		Char						// no ShortKey
	|	MenuMarkState		MarkState					// NoMark
	|	MenuFunction		(IOFunction		ps)			// \x->x
	|	MenuModsFunction	(ModsIOFunction	ps)			// MenuFunction

::	MenuType		:==	String
::	MenuElementType	:==	String
